/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.storage;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.GitRevList;
import com.aptana.git.core.model.GitRevSpecifier;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.internal.core.storage.CommitFileRevision;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;

public class GitFileHistory
extends FileHistory {
    private static final IFileRevision[] NO_FILE_REVISIONS = new IFileRevision[0];
    private static final CommitFileRevision[] NO_COMMIT_FILE_REVISIONS = new CommitFileRevision[0];
    private IResource resource;
    private final CommitFileRevision[] revisions;

    public GitFileHistory(IResource resource, int flags, IProgressMonitor monitor) {
        this.resource = resource;
        this.revisions = this.buildRevisions(flags, monitor);
    }

    private CommitFileRevision[] buildRevisions(int flags, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.resource == null || this.resource.getProject() == null) {
                CommitFileRevision[] commitFileRevisionArray = NO_COMMIT_FILE_REVISIONS;
                return commitFileRevisionArray;
            }
            GitRepository repo = this.getGitRepositoryManager().getAttached(this.resource.getProject());
            if (repo == null) {
                CommitFileRevision[] commitFileRevisionArray = NO_COMMIT_FILE_REVISIONS;
                return commitFileRevisionArray;
            }
            IPath resourcePath = repo.relativePath(this.resource);
            ArrayList<CommitFileRevision> revisions = new ArrayList<CommitFileRevision>();
            GitRevList list = new GitRevList(repo);
            int max = -1;
            if ((flags & 1) == 1) {
                max = 1;
            }
            list.walkRevisionListWithSpecifier(new GitRevSpecifier(resourcePath.toOSString()), max, (IProgressMonitor)subMonitor.newChild(95));
            List<GitCommit> commits = list.getCommits();
            for (GitCommit gitCommit : commits) {
                revisions.add(new CommitFileRevision(gitCommit, this.resource.getProjectRelativePath()));
            }
            CommitFileRevision[] commitFileRevisionArray = revisions.toArray(new CommitFileRevision[revisions.size()]);
            return commitFileRevisionArray;
        }
        finally {
            subMonitor.done();
        }
    }

    private IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        if (!(revision instanceof CommitFileRevision)) {
            return NO_FILE_REVISIONS;
        }
        CommitFileRevision arg = (CommitFileRevision)revision;
        ArrayList<CommitFileRevision> targets = new ArrayList<CommitFileRevision>();
        if (this.revisions != null) {
            CommitFileRevision[] commitFileRevisionArray = this.revisions;
            int n = this.revisions.length;
            int n2 = 0;
            while (n2 < n) {
                CommitFileRevision aRevision = commitFileRevisionArray[n2];
                if (arg.isDescendantOf((IFileRevision)aRevision)) {
                    targets.add(aRevision);
                }
                ++n2;
            }
        }
        return targets.toArray(new IFileRevision[targets.size()]);
    }

    public IFileRevision getFileRevision(String id) {
        if (this.revisions != null) {
            CommitFileRevision[] commitFileRevisionArray = this.revisions;
            int n = this.revisions.length;
            int n2 = 0;
            while (n2 < n) {
                CommitFileRevision revision = commitFileRevisionArray[n2];
                if (revision.getContentIdentifier().equals(id)) {
                    return revision;
                }
                ++n2;
            }
        }
        return null;
    }

    public IFileRevision[] getFileRevisions() {
        IFileRevision[] r = new IFileRevision[this.revisions.length];
        System.arraycopy(this.revisions, 0, r, 0, r.length);
        return r;
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        if (!(revision instanceof CommitFileRevision)) {
            return NO_FILE_REVISIONS;
        }
        ArrayList<CommitFileRevision> targets = new ArrayList<CommitFileRevision>();
        if (this.revisions != null) {
            CommitFileRevision[] commitFileRevisionArray = this.revisions;
            int n = this.revisions.length;
            int n2 = 0;
            while (n2 < n) {
                CommitFileRevision aRevision = commitFileRevisionArray[n2];
                if (aRevision.isDescendantOf(revision)) {
                    targets.add(aRevision);
                }
                ++n2;
            }
        }
        return targets.toArray(new IFileRevision[targets.size()]);
    }
}

